/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.memory;

import emulator.hardware.HwWord;
import emulator.hardware.bus.Bus;
import emulator.hardware.memory.UnmappedMemoryException;
import emulator.hardware.memory.UnmappedMemoryHandler;
import emulator.hardware.memory.UnmappedMemoryThrow;
import java.util.HashMap;

public class SparseMemory
implements Bus {
    HashMap<Integer, Byte> map = new HashMap();
    UnmappedMemoryHandler handler = new UnmappedMemoryThrow();

    @Override
    public int read(int address) throws UnmappedMemoryException {
        if (this.map.containsKey(address)) {
            return this.map.get(address) & 0xFF;
        }
        if (this.handler != null) {
            return (int)this.handler.read(new HwWord((long)address)).getNumber();
        }
        return 0;
    }

    @Override
    public void write(int address, int data) {
        this.map.put(address, (byte)data);
    }

    public void setUnmappedHandler(UnmappedMemoryHandler new_handler) {
        this.handler = new_handler;
    }
}

